/**************************************
 * Szerző:              Cseh Róbert
 * Szerző e-mail címe:  avr@tavir.hu
 * Készítés dátuma:     2024.08.20.
 * Projekt neve:        Soros kommunikáció minta 9 / DHT adathalmaz
 * Verzió:              1.0
 * Licenc:              Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) [https://creativecommons.org/licenses/by-nc-sa/4.0/deed]
 * Kapcsolódó cikk:     Soros plotter (diagrammok) az Arduino-1.x alatt [https://www.tavir.hu/tipp-soros-plotter-diagrammok-az-arduino-1-x-alatt/]
 * 
 * Leírás:
 *   Ez a program egy egyszerű példa a soros kommunikáció felépítéséhez.
 *   Egy DHT pára és hőfokadat küldés a PC felé - grafikus megjelenítéshez.
  *
 * Rendszerkövetelmények (tesztelési):
 * 
 *  Szoftverkövetelmény
 *    - Arduino IDE 1.8.13 (letölthető itt: www.arduino.cc/en/software)
 *  Hardver követelmény (Eszközök: [https://shop.tavir.hu])
 *    - Arduino UNO alappanel
 *    - Multifunction shield (HY-M302)
 *    
 * Bemenetek:   
 *  - DHT11: D4 láb
 * 
 * 
 * Verziókövetés:
 *   - V1.0: Első verzió
 * 
 **************************************/
 
#include <DHT.h>

#define DHTPIN 4          // DHT11 adatpin
#define DHTTYPE DHT11     // DHT11 típus
DHT dht(DHTPIN, DHTTYPE);

void setup() {
  Serial.begin(9600);     // Soros kommunikáció beállítása 9600 baud sebességgel
  dht.begin();            // DHT szenzor inicializálása
}

void loop() {
  float h = dht.readHumidity();    // Páratartalom mérése
  float t = dht.readTemperature(); // Hőmérséklet mérése

  if (isnan(h) || isnan(t)) {      // Hibaellenőrzés
    Serial.println("Hiba a szenzor olvasásakor!");
    return;
  }

  // Adatok küldése a soros porton
  Serial.print("Páratartalom[%]: ");
  Serial.print(h);
  Serial.print("\t");
  Serial.print("Hőmérséklet[°C]:");
  Serial.print(t);
  Serial.println("");
  
  delay(100); // 100 ms-os késleltetés a következő mérés előtt
}
