/**************************************
 * Szerző:              Cseh Róbert
 * Szerző e-mail címe:  avr@tavir.hu
 * Készítés dátuma:     2024.08.20.
 * Projekt neve:        Soros kommunikáció minta 7 / normalizált ppotméter
 * Verzió:              1.0
 * Licenc:              Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) [https://creativecommons.org/licenses/by-nc-sa/4.0/deed]
 * Kapcsolódó cikk:     Soros plotter (diagrammok) az Arduino-1.x alatt [https://www.tavir.hu/tipp-soros-plotter-diagrammok-az-arduino-1-x-alatt/]
 * 
 * Leírás:
 *   Ez a program egy egyszerű példa a soros kommunikáció felépítéséhez.
 *   Egy normalizált analóg adat kerül továbbítása a PC felé - grafikus megjelenítéshez. A potméter 0-100% tartományban mozog. Szélsőértéklimitálás opcionális!
 *
 * Rendszerkövetelmények (tesztelési):
 * 
 *  Szoftverkövetelmény
 *    - Arduino IDE 1.8.13 (letölthető itt: www.arduino.cc/en/software)
 *  Hardver követelmény (Eszközök: [https://shop.tavir.hu])
 *    - Arduino UNO alappanel
 *    - Multifunction shield (HY-M302)
 *    
 * Bemenetek:   
 *  - Analog0: Potméter (%)
 * 
 * 
 * Verziókövetés:
 *   - V1.0: Első verzió
 * 
 **************************************/
 
void setup() {
  Serial.begin(9600);                                 // Kommunikáció beállítása 9600 baud sebességgel
}

void loop() {                       
  // Potméter értékének beolvasása és átalakítása 0-100 tartományba
  int rawValue1 = analogRead(A0);                     // Nyers érték beolvasása (0-1023)
  int scaledValue1 = map(rawValue1, 0, 1023, 0, 100); // Átalakítás 0-100 tartományba

  // Adatok küldése soros porton
  Serial.println(scaledValue1);                       // Potméter érték (0-100)
  
  delay(10);                                          // Kis szünet
}
