/**************************************
 * Szerző:              Cseh Róbert
 * Szerző e-mail címe:  avr@tavir.hu
 * Készítés dátuma:     2024.08.20.
 * Projekt neve:        Soros kommunikáció minta 6 / grafikon - finomított mérésekkel, szélsőértékkel
 * Verzió:              1.0
 * Licenc:              Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) [https://creativecommons.org/licenses/by-nc-sa/4.0/deed]
 * Kapcsolódó cikk:     Soros plotter (diagrammok) az Arduino-1.x alatt [https://www.tavir.hu/tipp-soros-plotter-diagrammok-az-arduino-1-x-alatt/]
 * 
 * Leírás:
 *   Ez a program egy egyszerű példa a soros kommunikáció felépítéséhez.
 *   Több analóg adat továbbítása a PC felé - grafikus megjelenítéshez.
 *   A kód célja bemutatni a cikkben foglalt kommunikációt.
 *
 * Rendszerkövetelmények (tesztelési):
 * 
 *  Szoftverkövetelmény
 *    - Arduino IDE 1.8.13 (letölthető itt: www.arduino.cc/en/software)
 *  Hardver követelmény (Eszközök: [https://shop.tavir.hu])
 *    - Arduino UNO alappanel
 *    - Multifunction shield (HY-M302)
 *    
 * Bemenetek:   
 *  - Analog0: Potméter (%)
 *  - Analog1: Megvilágításmérő (Analóg adat)
 *  - Analog2: LM35DZ analóg hőmérő (Hőfok)
 * 
 * 
 * Verziókövetés:
 *   - V1.0: Első verzió
 * 
 **************************************/

 int MinMaxValue = 0;
 
void setup() {
  Serial.begin(9600);                         // Kommunikáció beállítása 9600 baud sebességgel
}

void loop() {                       
  // Potméter értékének beolvasása és átalakítása 0-100 tartományba
  int rawValue1 = analogRead(A0);             // Nyers érték beolvasása (0-1023)
  int sensorValue1 = map(rawValue1, 0, 1023, 0, 100); // Átalakítás 0-100 tartományba

  // Megvilágításmérő értékének beolvasása
  int sensorValue2 = analogRead(A1);

  // Hőmérséklet-érzékelő 20 minta átlagolása a legkisebb és legnagyobb értékek kiszűrésével
  const int numSamples = 20;
  float samples[numSamples];
  float voltage, sensorValue3;
  
  for (int i = 0; i < numSamples; i++) {
    int rawValue3 = analogRead(A2);           // Nyers érték beolvasása
    voltage = rawValue3 * (5.0 / 1023.0);     // Feszültség kiszámítása
    samples[i] = voltage * 100.0;             // Hőmérséklet Celsius-fokban
    delay(10);                                // Kis szünet a mérések között
  }

  // Sorba rendezés
  for (int i = 0; i < numSamples - 1; i++) {
    for (int j = i + 1; j < numSamples; j++) {
      if (samples[i] > samples[j]) {
        float temp = samples[i];
        samples[i] = samples[j];
        samples[j] = temp;
      }
    }
  }

  // Legkisebb 2 és legnagyobb 2 érték eldobása, maradék átlagolása
  float sum = 0;
  for (int i = 2; i < numSamples - 2; i++) {
    sum += samples[i];
  }
  sensorValue3 = sum / (numSamples - 4);

/* Csak a nyers számérték
  // Adatok küldése soros porton
  Serial.print(sensorValue1);         // Potméter érték (0-100)
  Serial.print("\t");                 // Tabulátorral elválasztva
  Serial.print(sensorValue2);         // Megvilágításmérő érték (0-1023)
  Serial.print("\t");               
  Serial.println(sensorValue3);       // Hőmérséklet Celsius-fokban
*/

  // Adatok küldése soros porton
  Serial.print("Potmeter[%]:");       // Potméter érték (0-100)
  Serial.print(sensorValue1);
  Serial.print(", ");                 // Vesszővel elválasztva
  Serial.print("Light[AD]:");         // Megvilágításmérő érték (0-1023)
  Serial.print(sensorValue2);
  Serial.print(", ");                 // Vesszővel elválasztva
  Serial.print("Temp[C]:");           // Hőmérséklet Celsius-fokban
  Serial.print(sensorValue3);
  Serial.print(", ");                 // Vesszővel elválasztva
  
  if (MinMaxValue%100 == 0) {
    Serial.println(0);                // Alsó limitérték
  } else {
    Serial.println(1024);             // Felső limitérték
  }
  MinMaxValue = MinMaxValue+1;
  
  Serial.println("");
  

  delay(10);                         // Kis szünet
}
