/**************************************
 * Szerző:              Cseh Róbert
 * Szerző e-mail címe:  avr@tavir.hu
 * Készítés dátuma:     2024.08.20.
 * Projekt neve:        Soros kommunikáció minta 5 / grafikon
 * Verzió:              1.0
 * Licenc:              Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) [https://creativecommons.org/licenses/by-nc-sa/4.0/deed]
 * Kapcsolódó cikk:     Soros plotter (diagrammok) az Arduino-1.x alatt [https://www.tavir.hu/tipp-soros-plotter-diagrammok-az-arduino-1-x-alatt/]
 * 
 * Leírás:
 *   Ez a program egy egyszerű példa a soros kommunikáció felépítéséhez.
 *   Több analóg adat továbbítása a PC felé - grafikus megjelenítéshez. Mértékegységgel, szövegesen.
 *   A kód célja bemutatni a cikkben foglalt kommunikációt.
 *
 * Rendszerkövetelmények (tesztelési):
 * 
 *  Szoftverkövetelmény
 *    - Arduino IDE 1.8.13 (letölthető itt: www.arduino.cc/en/software)
 *  Hardver követelmény (Eszközök: [https://shop.tavir.hu])
 *    - Arduino UNO alappanel
 *    - Multifunction shield (HY-M302)
 *    
 * Bemenetek:   
 *  - Analog0: Potméter (%)
 *  - Analog1: Megvilágításmérő (Analóg adat)
 *  - Analog2: LM35DZ analóg hőmérő (Hőfok)
 * 
 * 
 * Verziókövetés:
 *   - V1.0: Első verzió
 * 
 **************************************/

void setup() {
  Serial.begin(9600);               // Kommunikáció beállítása 9600 baud sebességgel
}

void loop() {                       
  // Potméter értékének beolvasása és átalakítása 0-100 tartományba
  int rawValue1 = analogRead(A0);   // Nyers érték beolvasása (0-1023)
  int sensorValue1 = map(rawValue1, 0, 1023, 0, 100); // Átalakítás 0-100 tartományba
  delay(5);

  // Megvilágításmérő értékének beolvasása
  int sensorValue2 = analogRead(A1);
  delay(5);

  // LM35DZ hőmérséklet-érzékelő beolvasása és átalakítása Celsius-fokra
  int rawValue3 = analogRead(A2);   // Nyers érték beolvasása (0-1023)
  float voltage = rawValue3 * (5.0 / 1023.0); // Feszültség kiszámítása (0-5V)
  float sensorValue3 = voltage * 100.0;      // Hőmérséklet kiszámítása (LM35DZ: 10mV/°C)

  // Adatok küldése soros porton
  Serial.print("Potmeter[%]:");       // Potméter érték (0-100)
  Serial.print(sensorValue1);
  Serial.print(", ");              // Vesszővel elválasztva
  Serial.print("Light[AD]:");          // Megvilágításmérő érték (0-1023)
  Serial.print(sensorValue2);
  Serial.print(", ");               // Vesszővel elválasztva
  Serial.print("Temp[C]:");           // Hőmérséklet Celsius-fokban
  Serial.print(sensorValue3);
  Serial.println("");
  
  delay(100);                       // Kis szünet
}
