/**************************************
 * Szerző:              Cseh Róbert
 * Szerző e-mail címe:  avr@tavir.hu
 * Készítés dátuma:     2024.08.20.
 * Projekt neve:        Soros kommunikáció minta 4
 * Verzió:              1.0
 * Licenc:              Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) [https://creativecommons.org/licenses/by-nc-sa/4.0/deed]
 * Kapcsolódó cikk:     Soros plotter (diagrammok) az Arduino-1.x alatt [https://www.tavir.hu/tipp-soros-plotter-diagrammok-az-arduino-1-x-alatt/]
 * 
 * Leírás:
 *   Ez a program egy egyszerű példa a soros kommunikáció felépítéséhez.
 *   Több analóg adat továbbítása a PC felé.
 *   A kód célja bemutatni a cikkben foglalt kommunikációt.
 *
 * Rendszerkövetelmények (tesztelési):
 * 
 *  Szoftverkövetelmény
 *    - Arduino IDE 1.8.13 (letölthető itt: www.arduino.cc/en/software)
 *  Hardver követelmény (Eszközök: [https://shop.tavir.hu])
 *    - Arduino UNO alappanel
 *    - Multifunction shield (HY-M302)
 *    
 * Bemenetek:   
 *  - Analog0: Potméter 
 *  - Analog1: Megvilágításmérő
 *  - Analog2: LM35DZ analóg hőmérő
 * 
 * 
 * Verziókövetés:
 *   - V1.0: Első verzió
 * 
 **************************************/

void setup() {
  Serial.begin(9600);               //Kommunikáció beállítása 9600 baud sebességgel
}

void loop() {                       // Példaként egy egyszerű adat küldése a soros porton
  int sensorValue1 = analogRead(A0);//Potméter értékének beolvasása
  int sensorValue2 = analogRead(A1);//Megvilágításmérő értékének beolvasása
  int sensorValue3 = analogRead(A2);//Analóg hőmérő beolvasása  

  Serial.print(sensorValue1);       //Adatok küldése
  Serial.print("\t");               //Tabulátorral elválasztva
  Serial.print(sensorValue2);
  Serial.print("\t");               
  Serial.println(sensorValue3);     //Utolsó adat zárása
 
  delay(100);                       //Kis szünet
}
