/*
  Program neve: Multifunctional Shield Tesztprogram
  Verzió: 1.1
  Dátum: 2024. augusztus 20.
  
  Szerző: Cseh Róbert
  E-mail: avr@tavir.hu
  Web: https://www.tavir.hu


  Leírás:
  Ez a program egy menüvezérelt tesztprogram, amely az Arduino UNO-hoz csatlakozó Multifunctional Shield (más néven HY-M302) különböző funkcióit teszteli.
  A program lehetőséget biztosít a buzzer, potenciométer, DHT11 szenzor, analóg fényérzékelő, LM35DZ hőmérsékletmérő chip, kék és piros LED-ek, RGB LED, infravevő, valamint két nyomógomb működésének ellenőrzésére.

  Hardverkövetelmények:
  - Arduino Uno
  - Multifunctional Shield (más néven HY-M302)
  - Buzzer (csatlakoztatva a D5 pinhez)
  - Potenciométer (csatlakoztatva az A0 analóg porthoz)
  - Fényérzékelő (csatlakoztatva az A1 analóg porthoz)
  - DHT11 szenzor (csatlakoztatva a D4 pinhez)
  - LM35DZ hőmérsékletmérő (csatlakoztatva az A2 analóg porthoz)
  - Kék LED (csatlakoztatva a D13 pinhez)
  - Piros LED (csatlakoztatva a D12 pinhez)
  - Infravevő (csatlakoztatva a D6 pinhez)
  - Nyomógomb1 (csatlakoztatva a D2 pinhez)
  - Nyomógomb2 (csatlakoztatva a D3 pinhez)
  - RGB LED (csatlakoztatva a D9-D11 pinhez)

  Könyvtárak:
  - DHT sensor library (Adafruit) - a DHT11 szenzor kezeléséhez
    Telepítés: Arduino IDE-ben a Library Manager segítségével, keresés: "DHT sensor library"

  Felhasználási feltételek:
  Szabadon felhasználható és módosítható oktatási célokra. A szerző nevének megőrzése szükséges.

*/
#include <DHT.h>

#define DHTPIN 4          // DHT11 adatpin
#define DHTTYPE DHT11     // DHT11 típus
DHT dht(DHTPIN, DHTTYPE);

#define BUZZER_PIN 5
#define POT_PIN A0
#define LIGHT_SENSOR_PIN A1
#define TEMP_SENSOR_PIN A2
#define BLUE_LED_PIN 13
#define RED_LED_PIN 12
#define IR_RECEIVER_PIN 6
#define BUTTON1_PIN 2
#define BUTTON2_PIN 3
#define RGB_RED_PIN 9
#define RGB_GREEN_PIN 10
#define RGB_BLUE_PIN 11

void setup() {
  Serial.begin(9600);
  pinMode(BUZZER_PIN, OUTPUT);
  pinMode(BLUE_LED_PIN, OUTPUT);
  pinMode(RED_LED_PIN, OUTPUT);
  pinMode(RGB_RED_PIN, OUTPUT);
  pinMode(RGB_GREEN_PIN, OUTPUT);
  pinMode(RGB_BLUE_PIN, OUTPUT);
  pinMode(IR_RECEIVER_PIN, INPUT);
  pinMode(BUTTON1_PIN, INPUT_PULLUP);
  pinMode(BUTTON2_PIN, INPUT_PULLUP);
  dht.begin();
}

void loop() {
  Serial.println("Válassz egy tesztet:");
  Serial.println("1. Buzzer teszt");
  Serial.println("2. Potenciométer teszt");
  Serial.println("3. DHT11 szenzor teszt");
  Serial.println("4. Fényérzékelő teszt");
  Serial.println("5. LM35DZ hőmérsékletmérő teszt");
  Serial.println("6. LED teszt (kék és piros)");
  Serial.println("7. RGB LED teszt");
  Serial.println("8. Nyomógomb teszt");
  Serial.println("9. Infravevő teszt");
  
  while (!Serial.available()); // Várakozás a felhasználó inputjára
  char choice = Serial.read();
  
  switch (choice) {
    case '1':
      buzzerTest();
      break;
    case '2':
      potentiometerTest();
      break;
    case '3':
      dht11Test();
      break;
    case '4':
      lightSensorTest();
      break;
    case '5':
      lm35Test();
      break;
    case '6':
      ledTest();
      break;
    case '7':
      rgbLedTest();
      break;
    case '8':
      buttonTest();
      break;
    case '9':
      irReceiverTest();
      break;
    default:
      Serial.println("Érvénytelen választás, próbáld újra.");
  }
  
  delay(2000); // Kis késleltetés a következő menü megjelenítéséhez
  Serial.flush(); // Soros buffer ürítése a vizsgálat után
}

void buzzerTest() {
  Serial.println("Buzzer teszt indul.");
  tone(BUZZER_PIN, 1000); // 1 kHz hangjelzés
  delay(1000);
  noTone(BUZZER_PIN);
  Serial.println("Buzzer teszt vége.");
}

void potentiometerTest() {
  Serial.println("Potenciométer teszt indul.");
  int value = analogRead(POT_PIN);
  Serial.print("Potenciométer érték: ");
  Serial.println(value);
}

void dht11Test() {
  Serial.println("DHT11 szenzor teszt indul.");
  float h = dht.readHumidity();
  float t = dht.readTemperature();
  
  if (isnan(h) || isnan(t)) {
    Serial.println("Hiba a szenzor olvasásakor!");
    return;
  }
  
  Serial.print("Páratartalom: ");
  Serial.print(h);
  Serial.println(" %");
  Serial.print("Hőmérséklet: ");
  Serial.print(t);
  Serial.println(" °C");
}

void lightSensorTest() {
  Serial.println("Fényérzékelő teszt indul.");
  int value = analogRead(LIGHT_SENSOR_PIN);
  Serial.print("Fényérzékelő érték: ");
  Serial.println(value);
}

void lm35Test() {
  Serial.println("LM35DZ hőmérsékletmérő teszt indul.");
  int value = analogRead(TEMP_SENSOR_PIN);
  float voltage = value * (5.0 / 1023.0);
  float temperatureC = voltage * 100; // LM35DZ: 10mV per °C
  Serial.print("Hőmérséklet: ");
  Serial.print(temperatureC);
  Serial.println(" °C");
}

void ledTest() {
  Serial.println("LED teszt indul.");
  digitalWrite(BLUE_LED_PIN, HIGH);
  delay(500);
  digitalWrite(BLUE_LED_PIN, LOW);
  digitalWrite(RED_LED_PIN, HIGH);
  delay(500);
  digitalWrite(RED_LED_PIN, LOW);
  Serial.println("LED teszt vége.");
}

void rgbLedTest() {
  Serial.println("RGB LED teszt indul.");
  analogWrite(RGB_RED_PIN, 255);   // Piros
  analogWrite(RGB_GREEN_PIN, 0);
  analogWrite(RGB_BLUE_PIN, 0);
  delay(1000);
  analogWrite(RGB_RED_PIN, 0);
  analogWrite(RGB_GREEN_PIN, 255); // Zöld
  analogWrite(RGB_BLUE_PIN, 0);
  delay(1000);
  analogWrite(RGB_RED_PIN, 0);
  analogWrite(RGB_GREEN_PIN, 0);
  analogWrite(RGB_BLUE_PIN, 255);  // Kék
  delay(1000);
  analogWrite(RGB_RED_PIN, 0);
  analogWrite(RGB_GREEN_PIN, 0);
  analogWrite(RGB_BLUE_PIN, 0);
  Serial.println("RGB LED teszt vége.");
}

void buttonTest() {
  Serial.println("Nyomógomb teszt indul.");
  Serial.print("Nyomógomb1 állapota: ");
  Serial.println(digitalRead(BUTTON1_PIN) == LOW ? "Lenyomva" : "Nincs lenyomva");
  Serial.print("Nyomógomb2 állapota: ");
  Serial.println(digitalRead(BUTTON2_PIN) == LOW ? "Lenyomva" : "Nincs lenyomva");
  Serial.println("Nyomógomb teszt vége.");
}

void irReceiverTest() {
  Serial.println("Infravevő teszt indul.");
  int value = digitalRead(IR_RECEIVER_PIN);
  Serial.print("Infravevő állapota: ");
  Serial.println(value == HIGH ? "Jel van" : "Nincs jel");
  Serial.println("Infravevő teszt vége.");
}
